#include <LPC17xx.H>                               // LPC17xx definitions

static uint32_t triangle[32];


static void T0_Init(void)
{
	/* select MAT0.0 at P1.28 */
    LPC_PINCON->PINSEL3 |= (3<<24); 

	/* 100 usec @ 25 Mhz */
    LPC_TIM0->MR0 = 2500; 

	/* interrupt on MR0, reset timer on match 0 */
    LPC_TIM0->MCR = 0x0003;
	
	/* toggle MAT0.0 pin on match */
    LPC_TIM0->EMR = 0x0031;

	/* Reset Timer */
    LPC_TIM0->TCR  = 2;
}

void ADC_Init(void)
{
	/* Turn on the ADC */
	LPC_SC->PCONP 	|= (1<<12);	
	LPC_ADC->ADCR	=	(1<<2) | (0x4<<8) | (1<<21);
	LPC_SC->PCLKSEL0 &= ~(0x3<<24);	// PCLK = clk/4	 100MHz / 4 = 25MHz

	/* Select P0.25 as AD0.2 for input */
	LPC_PINCON->PINSEL1	 = (LPC_PINCON->PINSEL1  & ~(0x3<<18)) | (1<<18);

	/* Disable Pullup and Pulldown resistors */
	LPC_PINCON->PINMODE1 = (LPC_PINCON->PINMODE1 & ~(0x3<<18)) | (0x2<<18);

	return;
}

void Start_Converstion(void){
	LPC_ADC->ADCR	|=	(1<<24);
	return;
}

uint32_t Get_ADC_value(void){
	/* Wait for conversion to complete */
	while(!(LPC_ADC->ADSTAT & (1<<2)));
	/* Return the conversion value */
	return ((LPC_ADC->ADDR2 >> 4) & (0xFFF));
}


int main (void)                                    // Main Program
{
  uint32_t i, t;

    SystemInit();

    T0_Init();
	ADC_Init();
	
	/* Select P0.16 as output */
	LPC_GPIO0->FIODIR |= 0x00010000;

    for(i=0; i!=16; i++) triangle[i] = (((i+1)<<6) - 1)<<6;
    for(i=0; i!=16; i++) triangle[16+i] = (((16-i)<<6) - 64)<<6;

	/* enable AOUT (P0.26) pin */
    LPC_PINCON->PINSEL1 |= (2<<20); 

	/* Select MAT0.0 instead of UART0 Tx */
    LPC_SC->DMAREQSEL = 0x01;

	/* Enable the GPDMA controller */
    LPC_GPDMA->DMACConfig = 1;

	/* Enable synchro logic request 8, MAT0.0 */
    LPC_GPDMA->DMACSync   = 1 << 8;

	for (;;)                                       // Loop forever
    {
        LPC_GPIO0->FIOPIN ^= 1 << 16;                  // Toggle P0.16
		Start_Converstion();

        LPC_GPDMACH0->DMACCSrcAddr  = (uint32_t) &triangle[0];
        LPC_GPDMACH0->DMACCDestAddr = (uint32_t) &(LPC_DAC->DACR);
        LPC_GPDMACH0->DMACCLLI      = 0;           // linked lists for ch0
        LPC_GPDMACH0->DMACCControl  = 32           // transfer size (0 - 11) = 32
                                | (0 << 12)        // source burst size (12 - 14) = 1
                                | (0 << 15)        // destination burst size (15 - 17) = 1
                                | (2 << 18)        // source width (18 - 20) = 32 bit
                                | (2 << 21)        // destination width (21 - 23) = 32 bit
                                | (0 << 24)        // source AHB select (24) = AHB 0
                                | (0 << 25)        // destination AHB select (25) = AHB 0
                                | (1 << 26)        // source increment (26) = increment
                                | (0 << 27)        // destination increment (27) = no increment
                                | (0 << 28)        // mode select (28) = access in user mode
                                | (0 << 29)        // (29) = access not bufferable
                                | (0 << 30)        // (30) = access not cacheable
                                | (0 << 31);       // terminal count interrupt disabled

        LPC_GPDMACH0->DMACCConfig   =  1           // channel enabled (0)
                                | (0 << 1)         // source peripheral (1 - 5) = none
                                | (8 << 6)         // destination request peripheral (6 - 10) = MAT0.0
                                | (1 << 11)        // flow control (11 - 13) = mem to per
                                | (0 << 14)        // (14) = mask out error interrupt
                                | (0 << 15)        // (15) = mask out terminal count interrupt
                                | (0 << 16)        // (16) = no locked transfers
                                | (0 << 18);       // (27) = no HALT
        
		LPC_TIM0->TCR = 1;                         // enable timer
        while (LPC_GPDMACH0->DMACCConfig & 1) ;    // wait for the DMA to finish
        LPC_TIM0->TCR = 0;                         // disable timer

		t =  Get_ADC_value();
		for (i=0; i<(1000 * t); i++);// Delay
    }
}
